import { StyleSheet } from "react-native";
import dpr from "../../../../Utilities/CustomStyleAttribute/dpr";

export const itemDetailsStyles = StyleSheet.create({
    ratingCont: {
        flexDirection: "row",
        justifyContent: "space-between",
        alignItems: "center",
        marginTop: dpr(20),
    },
    nameText: {
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(13),
        color: "#898989",
    },
    rating: {
        flexDirection: "row",
        alignItems: "center",
        position: "absolute",
        right: 0,
    },
    ratingText: {
        marginLeft: dpr(5),
    },
    title: {
        fontFamily: "DMSans_700Bold",
        fontSize: dpr(20),
        color: "#2C2C2C",
        marginTop: dpr(10),
        marginBottom: dpr(15),
        textAlign: 'left'
    },
    priceCont: {
        flexDirection: "row",
    },
    price: {
        fontFamily: "DMSans_700Bold",
        fontSize: dpr(20),
        color: "#FF6B00",
    },
    discount: {
        marginLeft: dpr(8),
        textDecorationLine: "line-through",
        color: "#CBCBCB",
        marginTop: "auto",
    },
    sizeCont: {
        flexDirection: "row",
        alignItems: "center",
        paddingVertical: dpr(15),
        borderBottomWidth: 1,
        borderColor: "#DFDFDF",
    },
    sizeText: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(16),
        color: "#2C2C2C",
        width: dpr(80),
    },
    totalSizeCont: {
        flexDirection: "row",
    },
    sizeItemCont: {
        marginLeft: dpr(10),
        flexDirection: "row",
        justifyContent: "center",
        alignItems: "center",
    },
    sizeItem: {
        fontFamily: "DMSans_500Medium",
        fontSize: dpr(14),
        color: "#2C2C2C",
    },
    activeBorderColor: {
        height: dpr(33),
        width: dpr(33),
        borderColor: "#FCCA19",
        borderRadius: 50,
        flexDirection: "row",
        justifyContent: "center",
        alignItems: "center",
    },
    colorItem: {
        width: dpr(24),
        height: dpr(24),
        borderRadius: 50,
        borderColor: "#DFDFDF",
        flexDirection: "row",
        justifyContent: "center",
        alignItems: "center",
    },
    availabilityCont: {
        marginTop: dpr(20),
        flexDirection: "row",
        alignItems: "center",
    },
    availabilityText: {
        fontSize: dpr(16),
        fontFamily: "DMSans_500Medium",
        color: "#2C2C2C",
    },
    stockText: (isStock) => ({
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(16),
        paddingHorizontal: dpr(20),
        paddingVertical: dpr(7),
        borderRadius: 2,
        color: !isStock ? "#009651" : "#E43147",
        backgroundColor: !isStock ? "#EBF9F1" : "#FFEEEE",
    }),
    stockQuantity: {
        marginLeft: dpr(12),
        fontFamily: "Roboto_500Medium",
        fontSize: dpr(14),
        color: "#898989",
    },
});
